<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Types\TypeUtils;

/**
 * Windows Autopilot Deployment Profile
*/
class WindowsAutopilotDeploymentProfile extends Entity implements Parsable 
{
    /**
     * Instantiates a new WindowsAutopilotDeploymentProfile and sets the default values.
    */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return WindowsAutopilotDeploymentProfile
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): WindowsAutopilotDeploymentProfile {
        return new WindowsAutopilotDeploymentProfile();
    }

    /**
     * Gets the assignedDevices property value. The list of assigned devices for the profile.
     * @return array<WindowsAutopilotDeviceIdentity>|null
    */
    public function getAssignedDevices(): ?array {
        $val = $this->getBackingStore()->get('assignedDevices');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, WindowsAutopilotDeviceIdentity::class);
            /** @var array<WindowsAutopilotDeviceIdentity>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'assignedDevices'");
    }

    /**
     * Gets the createdDateTime property value. The date and time of when the deployment profile was created. The value cannot be modified and is automatically populated when the profile was created. The timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported. Read-Only.
     * @return DateTime|null
    */
    public function getCreatedDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('createdDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'createdDateTime'");
    }

    /**
     * Gets the description property value. A description of the deployment profile. Max allowed length is 1500 chars. Supports: $select, $top, $skip, $orderBy. $Search and $filter are not supported.
     * @return string|null
    */
    public function getDescription(): ?string {
        $val = $this->getBackingStore()->get('description');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'description'");
    }

    /**
     * Gets the deviceNameTemplate property value. The template used to name the Autopilot device. This can be a custom text and can also contain either the serial number of the device, or a randomly generated number. The total length of the text generated by the template can be no more than 15 characters. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @return string|null
    */
    public function getDeviceNameTemplate(): ?string {
        $val = $this->getBackingStore()->get('deviceNameTemplate');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'deviceNameTemplate'");
    }

    /**
     * Gets the deviceType property value. The deviceType property
     * @return WindowsAutopilotDeviceType|null
    */
    public function getDeviceType(): ?WindowsAutopilotDeviceType {
        $val = $this->getBackingStore()->get('deviceType');
        if (is_null($val) || $val instanceof WindowsAutopilotDeviceType) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'deviceType'");
    }

    /**
     * Gets the displayName property value. The display name of the deployment profile. Max allowed length is 200 chars. Returned by default. Supports: $select, $top, $skip, $orderby. $Search and $filter are not supported.
     * @return string|null
    */
    public function getDisplayName(): ?string {
        $val = $this->getBackingStore()->get('displayName');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'displayName'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'assignedDevices' => fn(ParseNode $n) => $o->setAssignedDevices($n->getCollectionOfObjectValues([WindowsAutopilotDeviceIdentity::class, 'createFromDiscriminatorValue'])),
            'createdDateTime' => fn(ParseNode $n) => $o->setCreatedDateTime($n->getDateTimeValue()),
            'description' => fn(ParseNode $n) => $o->setDescription($n->getStringValue()),
            'deviceNameTemplate' => fn(ParseNode $n) => $o->setDeviceNameTemplate($n->getStringValue()),
            'deviceType' => fn(ParseNode $n) => $o->setDeviceType($n->getEnumValue(WindowsAutopilotDeviceType::class)),
            'displayName' => fn(ParseNode $n) => $o->setDisplayName($n->getStringValue()),
            'hardwareHashExtractionEnabled' => fn(ParseNode $n) => $o->setHardwareHashExtractionEnabled($n->getBooleanValue()),
            'lastModifiedDateTime' => fn(ParseNode $n) => $o->setLastModifiedDateTime($n->getDateTimeValue()),
            'locale' => fn(ParseNode $n) => $o->setLocale($n->getStringValue()),
            'managementServiceAppId' => fn(ParseNode $n) => $o->setManagementServiceAppId($n->getStringValue()),
            'outOfBoxExperienceSetting' => fn(ParseNode $n) => $o->setOutOfBoxExperienceSetting($n->getObjectValue([OutOfBoxExperienceSetting::class, 'createFromDiscriminatorValue'])),
            'preprovisioningAllowed' => fn(ParseNode $n) => $o->setPreprovisioningAllowed($n->getBooleanValue()),
            'roleScopeTagIds' => function (ParseNode $n) {
                $val = $n->getCollectionOfPrimitiveValues();
                if (is_array($val)) {
                    TypeUtils::validateCollectionValues($val, 'string');
                }
                /** @var array<string>|null $val */
                $this->setRoleScopeTagIds($val);
            },
        ]);
    }

    /**
     * Gets the hardwareHashExtractionEnabled property value. Indicates whether the profile supports the extraction of hardware hash values and registration of the device into Windows Autopilot. When TRUE, indicates if hardware extraction and Windows Autopilot registration will happen on the next successful check-in. When FALSE, hardware hash extraction and Windows Autopilot registration will not happen. Default value is FALSE. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @return bool|null
    */
    public function getHardwareHashExtractionEnabled(): ?bool {
        $val = $this->getBackingStore()->get('hardwareHashExtractionEnabled');
        if (is_null($val) || is_bool($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'hardwareHashExtractionEnabled'");
    }

    /**
     * Gets the lastModifiedDateTime property value. The date and time of when the deployment profile was last modified. The value cannot be updated manually and is automatically populated when any changes are made to the profile. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported Read-Only.
     * @return DateTime|null
    */
    public function getLastModifiedDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastModifiedDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastModifiedDateTime'");
    }

    /**
     * Gets the locale property value. The locale (language) to be used when configuring the device. E.g. en-US. The default value is os-default. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @return string|null
    */
    public function getLocale(): ?string {
        $val = $this->getBackingStore()->get('locale');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'locale'");
    }

    /**
     * Gets the managementServiceAppId property value. The Entra management service App ID which gets used during client device-based enrollment discovery. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @return string|null
    */
    public function getManagementServiceAppId(): ?string {
        $val = $this->getBackingStore()->get('managementServiceAppId');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'managementServiceAppId'");
    }

    /**
     * Gets the outOfBoxExperienceSetting property value. The Windows Autopilot Deployment Profile settings used by the device for the out-of-box experience. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @return OutOfBoxExperienceSetting|null
    */
    public function getOutOfBoxExperienceSetting(): ?OutOfBoxExperienceSetting {
        $val = $this->getBackingStore()->get('outOfBoxExperienceSetting');
        if (is_null($val) || $val instanceof OutOfBoxExperienceSetting) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'outOfBoxExperienceSetting'");
    }

    /**
     * Gets the preprovisioningAllowed property value. Indicates whether the user is allowed to use Windows Autopilot for pre-provisioned deployment mode during Out of Box experience (OOBE). When TRUE, indicates that Windows Autopilot for pre-provisioned deployment mode for OOBE is allowed to be used. When false, Windows Autopilot for pre-provisioned deployment mode for OOBE is not allowed. The default is FALSE.
     * @return bool|null
    */
    public function getPreprovisioningAllowed(): ?bool {
        $val = $this->getBackingStore()->get('preprovisioningAllowed');
        if (is_null($val) || is_bool($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'preprovisioningAllowed'");
    }

    /**
     * Gets the roleScopeTagIds property value. List of role scope tags for the deployment profile. 
     * @return array<string>|null
    */
    public function getRoleScopeTagIds(): ?array {
        $val = $this->getBackingStore()->get('roleScopeTagIds');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, 'string');
            /** @var array<string>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'roleScopeTagIds'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeCollectionOfObjectValues('assignedDevices', $this->getAssignedDevices());
        $writer->writeDateTimeValue('createdDateTime', $this->getCreatedDateTime());
        $writer->writeStringValue('description', $this->getDescription());
        $writer->writeStringValue('deviceNameTemplate', $this->getDeviceNameTemplate());
        $writer->writeEnumValue('deviceType', $this->getDeviceType());
        $writer->writeStringValue('displayName', $this->getDisplayName());
        $writer->writeBooleanValue('hardwareHashExtractionEnabled', $this->getHardwareHashExtractionEnabled());
        $writer->writeDateTimeValue('lastModifiedDateTime', $this->getLastModifiedDateTime());
        $writer->writeStringValue('locale', $this->getLocale());
        $writer->writeStringValue('managementServiceAppId', $this->getManagementServiceAppId());
        $writer->writeObjectValue('outOfBoxExperienceSetting', $this->getOutOfBoxExperienceSetting());
        $writer->writeBooleanValue('preprovisioningAllowed', $this->getPreprovisioningAllowed());
        $writer->writeCollectionOfPrimitiveValues('roleScopeTagIds', $this->getRoleScopeTagIds());
    }

    /**
     * Sets the assignedDevices property value. The list of assigned devices for the profile.
     * @param array<WindowsAutopilotDeviceIdentity>|null $value Value to set for the assignedDevices property.
    */
    public function setAssignedDevices(?array $value): void {
        $this->getBackingStore()->set('assignedDevices', $value);
    }

    /**
     * Sets the createdDateTime property value. The date and time of when the deployment profile was created. The value cannot be modified and is automatically populated when the profile was created. The timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported. Read-Only.
     * @param DateTime|null $value Value to set for the createdDateTime property.
    */
    public function setCreatedDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('createdDateTime', $value);
    }

    /**
     * Sets the description property value. A description of the deployment profile. Max allowed length is 1500 chars. Supports: $select, $top, $skip, $orderBy. $Search and $filter are not supported.
     * @param string|null $value Value to set for the description property.
    */
    public function setDescription(?string $value): void {
        $this->getBackingStore()->set('description', $value);
    }

    /**
     * Sets the deviceNameTemplate property value. The template used to name the Autopilot device. This can be a custom text and can also contain either the serial number of the device, or a randomly generated number. The total length of the text generated by the template can be no more than 15 characters. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @param string|null $value Value to set for the deviceNameTemplate property.
    */
    public function setDeviceNameTemplate(?string $value): void {
        $this->getBackingStore()->set('deviceNameTemplate', $value);
    }

    /**
     * Sets the deviceType property value. The deviceType property
     * @param WindowsAutopilotDeviceType|null $value Value to set for the deviceType property.
    */
    public function setDeviceType(?WindowsAutopilotDeviceType $value): void {
        $this->getBackingStore()->set('deviceType', $value);
    }

    /**
     * Sets the displayName property value. The display name of the deployment profile. Max allowed length is 200 chars. Returned by default. Supports: $select, $top, $skip, $orderby. $Search and $filter are not supported.
     * @param string|null $value Value to set for the displayName property.
    */
    public function setDisplayName(?string $value): void {
        $this->getBackingStore()->set('displayName', $value);
    }

    /**
     * Sets the hardwareHashExtractionEnabled property value. Indicates whether the profile supports the extraction of hardware hash values and registration of the device into Windows Autopilot. When TRUE, indicates if hardware extraction and Windows Autopilot registration will happen on the next successful check-in. When FALSE, hardware hash extraction and Windows Autopilot registration will not happen. Default value is FALSE. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @param bool|null $value Value to set for the hardwareHashExtractionEnabled property.
    */
    public function setHardwareHashExtractionEnabled(?bool $value): void {
        $this->getBackingStore()->set('hardwareHashExtractionEnabled', $value);
    }

    /**
     * Sets the lastModifiedDateTime property value. The date and time of when the deployment profile was last modified. The value cannot be updated manually and is automatically populated when any changes are made to the profile. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported Read-Only.
     * @param DateTime|null $value Value to set for the lastModifiedDateTime property.
    */
    public function setLastModifiedDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastModifiedDateTime', $value);
    }

    /**
     * Sets the locale property value. The locale (language) to be used when configuring the device. E.g. en-US. The default value is os-default. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @param string|null $value Value to set for the locale property.
    */
    public function setLocale(?string $value): void {
        $this->getBackingStore()->set('locale', $value);
    }

    /**
     * Sets the managementServiceAppId property value. The Entra management service App ID which gets used during client device-based enrollment discovery. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @param string|null $value Value to set for the managementServiceAppId property.
    */
    public function setManagementServiceAppId(?string $value): void {
        $this->getBackingStore()->set('managementServiceAppId', $value);
    }

    /**
     * Sets the outOfBoxExperienceSetting property value. The Windows Autopilot Deployment Profile settings used by the device for the out-of-box experience. Supports: $select, $top, $skip. $Search, $orderBy and $filter are not supported.
     * @param OutOfBoxExperienceSetting|null $value Value to set for the outOfBoxExperienceSetting property.
    */
    public function setOutOfBoxExperienceSetting(?OutOfBoxExperienceSetting $value): void {
        $this->getBackingStore()->set('outOfBoxExperienceSetting', $value);
    }

    /**
     * Sets the preprovisioningAllowed property value. Indicates whether the user is allowed to use Windows Autopilot for pre-provisioned deployment mode during Out of Box experience (OOBE). When TRUE, indicates that Windows Autopilot for pre-provisioned deployment mode for OOBE is allowed to be used. When false, Windows Autopilot for pre-provisioned deployment mode for OOBE is not allowed. The default is FALSE.
     * @param bool|null $value Value to set for the preprovisioningAllowed property.
    */
    public function setPreprovisioningAllowed(?bool $value): void {
        $this->getBackingStore()->set('preprovisioningAllowed', $value);
    }

    /**
     * Sets the roleScopeTagIds property value. List of role scope tags for the deployment profile. 
     * @param array<string>|null $value Value to set for the roleScopeTagIds property.
    */
    public function setRoleScopeTagIds(?array $value): void {
        $this->getBackingStore()->set('roleScopeTagIds', $value);
    }

}
