<x-guest-layout>
    <div class="container-fluid h-100">
        <div class="row flex-row h-100 bg-white">
            <div class="col-xl-8 col-lg-6 col-md-5 p-0 d-md-block d-lg-block d-sm-none d-none">
                <div class="lavalite-bg" style="background-image: url('assets/temptk/img/auth/login-bg.png')">
                    <div class="lavalite-overlay"></div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-6 col-md-7 my-auto p-0" style="height:600px; overflow-y: scroll;">
                <div class="authentication-form mx-auto">
                    <div class="logo-left">
                        <a href="{{ route('login') }}"><img src="{{ asset('assets/temptk/img/auth/logoP.png')}}" alt=""></a>
                    </div>
                    <h3 class="text-center">Virtualex</h3>



                    <p class="text-center">Siempre contigo.</p>
                    <form method="POST" action="{{ route('register') }}" >
                        @csrf
                        <!-- Validation Errors -->
                        <x-auth-validation-errors class="mb-4 alert alert-warning" :errors="$errors" />
                        @if (\Session::has('errorscod'))
                        <div class="alert alert-warning" role="alert">
                            {!! \Session::get('errorscod') !!}
                        </div>
                        @endif
                        <div class="form-group">
                            <input id="name" type="text" class="form-control" name="name" :value="old('name')" required autofocus placeholder="Nombre">
                            <i class="ik ik-user"></i>
                        </div>
                        <div class="form-group">
                            <input id="email" class="form-control" type="email" name="email" :value="old('email')" required placeholder="Correo">
                            <i class="ik ik-mail"></i>
                        </div>
                        <div class="form-group">
                            <input id="password" class="form-control" type="password" name="password" required autocomplete="new-password" placeholder="Clave">
                            <i class="ik ik-lock"></i>
                        </div>
                        <div class="form-group">
                            <input id="password_confirmation" class="form-control" type="password" name="password_confirmation" required  placeholder="Confirmar Clave">
                            <i class="ik ik-eye-off"></i>
                        </div>
                        <div class="form-group">
                            <input id="codigo" class="form-control" type="text" name="codigo" :value="old('codigo')" required placeholder="Código Clínica" onchange="verificaCodigo()">
                            <i class="ik ik-shield"></i>
                        </div>
                        <div class="row">
                            <div class="col-12 text-left">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="terminos_y_condiciones" name="terminos_y_condiciones" value="true">
                                    <span class="custom-control-label">&nbsp;Acepta los <a href="#" data-toggle="modal" data-target="#exampleModalLong">Términos de uso</a></span>
                                </label>
                            </div>
                        </div>
                        <div class="sign-btn text-center">
                            <x-button class="btn btn-theme">
                                {{ __('Register') }}
                            </x-button>
                        </div>
                    </form>
                    <div class="register">
                        <p>Ya tienes una cuenta? <a href="{{ route('login') }}">Ingresar</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Inicio Modal-->
    <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongLabel">Términos de uso de Hipnohouse</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" >
                    <div class=3DWordSection1>
                        @include('auth._terminos')
                    </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        function verificaCodigo(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: 'aucodigo/verificaCod',
                type: "get",
                dataType: "JSON",
                data:{  codigo:$("#codigo").val()},
                success: function(result, textStatus){
                    console.log(result);
                     //   console.log('Dato correcto');
                },
                error: function(jqXHR, reponseData, errorThrown){
                   $("#codigo").val('')
                    //console.log('Dato incorrecto');
                    console.log(errorThrown);
                },
                complete: function(jqXHR, data){
                    console.log(data);
                }
            });
        }
    </script>
</x-guest-layout>
