<?php

namespace App\Http\Controllers;
use App\Models\Organizacion;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\tbempresauser;
use App\Models\tbempresa;
use App\Models\Role;

use Illuminate\Support\Facades\Storage;
use App\Models\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Clases\Utilidades;
use Lang;

class UserController extends Controller
{
    protected $return;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct( )
    {
        $this->middleware('auth',['admin', 'supadmin']);
        $this->return = (object)[
            'response' => false
        ];
        $this->_util=new Utilidades();


    }
    public function index(Request $req)
    {
        
        $this->_util->inicializaMenu($req);
        $req->session()->put('activeAdmin',  Lang::get('auth.activeAdmin'));
        $req->session()->put('varUser',  Lang::get('auth.active'));
        $req->session()->put('breadCumbp',Lang::get('auth.breadcumUser'));
        $req->session()->put('breadCumbs',Lang::get('auth.detailbreadcumUser'));
        $req->session()->put('breadImg', Lang::get('auth.icoUser'));

        $users=null;
        if(Auth::user()->hasRole(['supadmin'])){
            $users = DB::table('users')
            ->join('role_user', 'users.id', '=', 'role_user.user_id')
            ->join('roles', 'role_user.role_id', '=', 'roles.id')
            ->leftJoin('tbempresauser','users.id','=','tbempresauser.iduser')
            ->leftJoin('tbempresa','tbempresa.idemp','=','tbempresauser.idemp')
            ->select(
            'users.id',
                'users.name',
                'users.email',
                'users.codigo',
                'users.estado',
                'users.created_at',
                'roles.display_name as role',
                'tbempresa.nombre as empresa'
            )
            ->orderBy('users.id')
            ->paginate(20);
        }else{
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->join('roles', 'role_user.role_id', '=', 'roles.id')
                ->join('tbempresauser','users.id','=','tbempresauser.iduser')
                ->where('tbempresauser.idemp', '=',session('empresa'))
                ->select(
                    'users.id',
                    'users.name',
                    'users.email',
                    'users.codigo',
                    'users.estado',
                    'users.created_at',
                    'roles.display_name as role'
                )
                ->orderBy('users.id')
                ->paginate(20);
        }

            return view(
            'admin.users.index',['model'=>$users]
        );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $user=User::create($request->only('name','email','estado','reporte','create_at')
                +[
                    'password'=>bcrypt($request->input('password')),
                ]);

            $user->addRole($request->input('role'));

            /**
             * Relacion con usuario y empresa
             */
            if(Auth::user()->hasRole(['supadmin'])){

                $empresauser = tbempresauser::where('iduser',$user->id);
                $empresauser->delete();
                $idemp=$request->input('emp');
                
                if(isset($idemp)){                    
                    foreach($idemp as $emp){
                        $org= Organizacion::select('org_id','org_nombre','org_ruc')->where('org_id','=',$emp)->first();
                        $empresa= tbempresa::where('idemp',$emp)->first();
                        if(empty($empresa)){
                            tbempresa::create(['idemp'=>$emp,'nombre'=>$org->org_nombre,'ruc'=>$org->org_ruc]);
                        }
                        tbempresauser::create(['iduser'=>$user->id,'idemp'=>$emp]);
                    }
                }
            }
            else{
               tbempresauser::create(['iduser'=>$user->id,'idemp'=>session('empresa')]);
            }
            DB::commit();
            $this->return=true;
        } catch (\Exception $e){
            $this->return=false;
            DB::rollBack();
            if(env('APP_DEBUG')==true)
                echo"Error:".$e;
        }
        return json_encode($this->return);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $users = DB::table('users')
            ->join('role_user', 'users.id', '=', 'role_user.user_id')
            ->join('roles', 'role_user.role_id', '=', 'roles.id')
            ->leftJoin('tbempresauser','users.id','=','tbempresauser.iduser')
            //->where('tbempresauser.idemp', '=',session('empresa'))
            ->where('users.id','=',$id)
            ->select(
                'users.id',
                'users.name',
                'users.email',
                'users.codigo',
                'users.estado',
                'users.reporte',
                'users.created_at',
                'roles.display_name as role',
                'roles.name as perfil',
                'tbempresauser.idemp as emp'
            )
            ->orderBy('users.id')
            ->get();

        return json_encode($users);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $return = (object)[
            'response' => false,
            'idpago'=>''
        ];
        try {
            DB::beginTransaction();
            $user=User::findOrFail($request->input('id'));
            $user->roles()->detach();
            if(trim($request->password)==''){
                $data=$request->except('password');
            }else{
                $data=$request->all();
                $data['password']=bcrypt($request->password);
            }
            $user->update($data);
            /**
             * Relaciona usuario y rol
             */
             $user->addRole($request->input('role'));
            //$user->attachRole($request->input('role'));
            /**
             * Relacion con usuario y empresa
             */
            if(Auth::user()->hasRole(['supadmin'])){
                $empresauser = tbempresauser::where('iduser',$user->id);
                $empresauser->delete();
                $idemp=$request->input('emp');

                if(isset($idemp)){                    
                    foreach($idemp as $emp){
                        $org= Organizacion::select('org_id','org_nombre','org_ruc')->where('org_id','=',$emp)->first();
                        $empresa= tbempresa::where('idemp',$emp)->first();
                        if(empty($empresa)){
                            tbempresa::create(['idemp'=>$emp,'nombre'=>$org->org_nombre,'ruc'=>$org->org_ruc]);
                        }
                        tbempresauser::create(['iduser'=>$user->id,'idemp'=>$emp]);
                    }
                }

            }

            DB::commit();
            $this->return=true;
        } catch (\Exception $e){
            DB::rollBack();
            $this->return=false;
            if(env('APP_DEBUG')==true)
                echo"Error:".$e;
        }
        return json_encode($this->return);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function getRol(){
        $roles= DB::table('roles')
        ->where('roles.visible','=',1)
            ->select(
                'roles.name',
                'roles.display_name as role'
            )
            ->orderBy('roles.name')
            ->get();

        return json_encode($roles);
    }
    public function empresa(){
        //$odbOrg = new organizacion();
        $org= organizacion::orderBy('org_nombre','asc')->select('org_id','org_nombre')->get();
        return json_encode($org);
    }



}
