<x-app-layout>

@if(!Auth::user()->hasRole(['supadmin']))
    <div class="row mb-4">
        <div id="response"></div>
        <!-- product profit start -->
        <div class="card-group col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="state">
                            <h5 class="text-primary"><b>{{ number_format($sessionSize, 0, '.', ',') }}</b></h5>
                            <p class="card-subtitle text-muted fw-500">Accesos Integración</p>
                        </div>
                        <div class="icon">
                            <i class="ik ik-log-in text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="state">
                            <h5 class="text-danger"><b>{{ number_format($documentSize, 0, '.', ',') }}</b></h5>
                            <p class="card-subtitle text-muted fw-500">Descargas</p>
                        </div>
                        <div class="icon">
                            <i class="ik ik-download-cloud text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="state">
                            <h5 class="text-info"><b>{{ number_format( $notificationSize, 0, '.', ',') }}</b></h5>
                            <p class="card-subtitle text-muted fw-500">Notificaciones Diarias</p>
                        </div>
                        <div class="icon">
                            <i class="ik ik-message-square text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- product profit end -->
    </div>

       <!-- Filter Section Start -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                     {{ html()->form('GET', '','FrmReport')->open() }}       
                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="start_date">Fecha Inicio</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" required value="{{ $start_date }}">
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="end_date">Fecha Fin</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" required value="{{ $end_date }}">
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Filtrar</button>
                            </div>
                        </div>
                      {{ html()->form()->close() }}     
                </div>
            </div>
        </div>
    </div>
    <!-- Filter Section End -->

    <div class="row">
        <div class="col-xl-6 col-md-6">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Accesos Integración </h4>
                    <div class="card-header-right">
                        <a id="downloadAcces" class="btn btn-primary">
                            <i class="ik ik-download download text-white"></i></a>
                        {{-- <ul class="list-unstyled card-option">
                            <li><i class="ik ik-chevron-left action-toggle">xx</i></li>
                            <li><a id="downloadAcces"><i class="ik ik-download download"></i></a></li>                            
                             <li><i class="ik ik-x close-card"></i></li> 
                                                  </ul> --}}
                    </div>
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="myChart" width="400" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-md-6">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Accesos Integración por Mes</h4>
                    <div class="card-header-right">
                    {{--<ul class="list-unstyled card-option">
                         <li><i class="ik ik-chevron-left action-toggle"></i></li>
                            <li><i class="ik ik-minus minimize-card"></i></li>
                            <li><i class="ik ik-x close-card"></i></li>
                        </ul>--}}
                    </div>
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="userChart" width="400" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-6 col-md-6">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Descargas mensuales </h4>
                    <div class="card-header-right">
                        <a id="downloadDocument" class="btn btn-primary"> <i class="ik ik-download download text-white"></i></a>
                    </div>
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="historicalChart" width="400" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-md-6">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Reporte Apertura de Boletines </h4>
                    <div class="card-header-right">
                        <a id="downloadBulletins" class="btn btn-primary"> <i class="ik ik-download download text-white"></i></a>
                    </div>
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="BoletinesChart" width="400" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Chart 1
            const sessionData = @json($sessionData);
            const productLabels = sessionData.map(item => item.nombre);
            const totalData = sessionData.map(item => item.total);

            const ctx1 = document.getElementById('myChart').getContext('2d');
            new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: productLabels,
                    datasets: [
                        {
                            label: 'Accesos Integración',
                            data: totalData,
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }                        
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

            // Chart 2
            const sessionMesData = @json($sessionMesData);
            const userLabels = sessionMesData.map(item => item.mesNombre);
            const registrosData = sessionMesData.map(item => item.total);

            const ctx2 = document.getElementById('userChart').getContext('2d');
            new Chart(ctx2, {
                type: 'pie',
                data: {
                    labels: userLabels,
                    datasets: [{
                        label: 'Registros',
                        data: registrosData,
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.2)',
                            'rgba(54, 162, 235, 0.2)',
                            'rgba(255, 206, 86, 0.2)'
                        ],
                        borderColor: [
                            'rgba(255, 99, 132, 1)',
                            'rgba(54, 162, 235, 1)',
                            'rgba(255, 206, 86, 1)'
                        ],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    label += context.raw;
                                    return label;
                                }
                            }
                        }
                    }
                }
            });

            // Chart 3

            const documentMonthData = @json($documentMonthData);
            const documentLabels = documentMonthData.map(item => item.nombre);
            const documenttotalData = documentMonthData.map(item => item.total);

            const ctx3 = document.getElementById('historicalChart').getContext('2d');
            new Chart(ctx3, {
                type: 'bar',
                data: {
                    labels: documentLabels,
                    datasets: [
                        {
                            label: 'Descargas mensuales',
                            data: documenttotalData,
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }                       
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
            // Chart 3

            const notifications = @json($notifications);
            const notificationsLabels = notifications.map(item => item.nombre);
            const notificationstotalData = notifications.map(item => item.total);

            const ctx4 = document.getElementById('BoletinesChart').getContext('2d');
            new Chart(ctx4, {
                type: 'bar',
                data: {
                    labels: notificationsLabels,
                    datasets: [
                        {
                            label: 'Reporte Apertura de Boletines',
                            data: notificationstotalData,
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }                       
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });

        });


        //Descarga accesos externos
        document.getElementById('downloadAcces').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadAcces') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
        //Descarga documentos
        document.getElementById('downloadDocument').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadDocument') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
        //Descarga Boletines
        document.getElementById('downloadBulletins').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadBulletins') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
    </script>
@else
       <!-- Filter Section Start -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                     {{ html()->form('GET', '','FrmReport')->open() }}       
                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="start_date">Fecha Inicio</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" required value="{{ $start_date }}">
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="end_date">Fecha Fin</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" required value="{{ $end_date }}">
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Filtrar</button>
                            </div>
                        </div>
                      {{ html()->form()->close() }}     
                </div>
            </div>
        </div>
    </div>
    <!-- Filter Section End -->

    <div class="row">
        <div class="col-xl-12 col-md-12">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Accesos Integración </h4>
                    {{--  <div class="card-header-right">
                        <a id="downloadAcces" class="btn btn-primary">
                         <i class="ik ik-download download text-white"></i></a>
                        <ul class="list-unstyled card-option">
                            <li><i class="ik ik-chevron-left action-toggle">xx</i></li>
                            <li><a id="downloadAcces"><i class="ik ik-download download"></i></a></li>                            
                             <li><i class="ik ik-x close-card"></i></li> 
                                                  </ul> 
                    </div> --}}
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="myChart" width="800" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
     </div>
     <div class="row">
        <div class="col-xl-12 col-md-12">
            <div class="card table-card">
                <div class="card-header">
                    <h4>Descargas mensuales </h4>
                    {{-- <div class="card-header-right">
                   <a id="downloadDocument" class="btn btn-primary"> <i class="ik ik-download download text-white"></i></a>
                    </div> --}}
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <canvas id="historicalChart" width="800" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Chart 1
            const sessionData = @json($integracionsAdmin);
            const productLabels = sessionData.map(item => item.org_nombre);
            const totalData = sessionData.map(item => item.total_sessions);

            const ctx1 = document.getElementById('myChart').getContext('2d');
            new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: productLabels,
                    datasets: [
                        {
                            label: 'Accesos Integración',
                            data: totalData,
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }                        
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
            // Chart 2

            const documentMonthData = @json($documentAdmin);
            const documentLabels = documentMonthData.map(item => item.org_nombre);
            const documenttotalData = documentMonthData.map(item => item.total);

            const ctx3 = document.getElementById('historicalChart').getContext('2d');
            new Chart(ctx3, {
                type: 'bar',
                data: {
                    labels: documentLabels,
                    datasets: [
                        {
                            label: 'Descargas mensuales',
                            data: documenttotalData,
                            backgroundColor: 'rgba(75, 192, 192, 0.2)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 1
                        }                       
                    ]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
           
        });


        //Descarga accesos externos
        document.getElementById('downloadAcces').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadAcces') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
        //Descarga documentos
        document.getElementById('downloadDocument').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadDocument') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
        //Descarga Boletines
        document.getElementById('downloadBulletins').onclick = function() {
            const startDate = document.getElementById('start_date').value;
            const endDate = document.getElementById('end_date').value;
            const link = document.createElement('a');
            link.href = `{{ route('downloadBulletins') }}?start_date=${startDate}&end_date=${endDate}`;
            link.click();
        };
    </script>

@endif

</x-app-layout>
