<x-guest-layout>
    <x-auth-card>
        <div class="flex flex-col items-center justify-center min-h-screen">
            <x-slot name="logo">
                <a href="https://app.virtualex.ec/" class="flex justify-center">
                    <img src="{{ asset('assets/temptk/img/logoMail.png') }}" class="w-20 h-20" alt="Logo">
                </a>
            </x-slot>

            <!-- Validation Errors -->
            <x-auth-validation-errors class="mb-4" :errors="$errors" />

            <form method="POST" action="{{ route('password.update') }}" class="w-full max-w-md">
                @csrf

                <!-- Password Reset Token -->
                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                <!-- Email Address -->
                <div class="flex flex-col items-center">
                    <x-label for="email" :value="__('Email')" />

                    <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email', $request->email)" required autofocus />
                </div>

                <!-- Password -->
                <div class="mt-4 flex flex-col items-center">
                    <x-label for="password" :value="__('Password')" />

                    <x-input id="password" class="block mt-1 w-full" type="password" name="password" required />
                </div>

                <!-- Confirm Password -->
                <div class="mt-4 flex flex-col items-center">
                    <x-label for="password_confirmation" :value="__('Confirm Password')" />

                    <x-input id="password_confirmation" class="block mt-1 w-full"
                                        type="password"
                                        name="password_confirmation" required />
                </div>
                <div class="mt-4 flex flex-col items-center">
                    <label>
                   Tu contraseña debe tener al menos 8 caracteres y no incluir información personal como tu nombre 
                   o fecha de nacimiento
                </label>
                </div>

                <div class="flex items-center justify-center mt-4">
                    <x-button class="bg-info hover:bg-info-dark">
                        {{ __('Reset Password') }}
                    </x-button>
                </div>
            </form>
        </div>
    </x-auth-card>
</x-guest-layout>
