<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Clases\Utilidades;
use Lang;
use App\Models\Organizacion;
use App\Models\tbempresauser As EmpresaUser;
use App\Models\Sesexterna;
use App\Models\Topdoc;
use App\Models\Notifications;
use App\Models\Documento;
use Illuminate\Support\Facades\DB;

class ReportsController extends Controller
{
    private $_util;
    private $_tbconfigRepo;
    private $_pages;
    public function __construct()
    {
        $this->middleware('auth');
        $this->_pages = 30;
        $this->_util=new Utilidades();
    }
    public function index(Request $req)
    {
        $isUser=false;
        $userCoop="";
        if(Auth::user()->hasRole(['user'])){
            $isUser=true;
            $userCoop=auth()->user()->idcoop;
            if($userCoop == null){
                return redirect()->back()->with('status','Existe un problema al cargar los datos, por favor revise su informacion');
            }
        }


        $this->_util->inicializaMenu($req);
        $req->session()->put('activeInfo',  Lang::get('menu.actIng'));
        $req->session()->put('varIngrep',  Lang::get('menu.active'));
        $req->session()->put('breadCumbp',Lang::get('menu.breadcumfact'));
        $req->session()->put('breadCumbs',Lang::get('menu.detailbreadcumfact'));
        $req->session()->put('breadImg', Lang::get('menu.icofact'));


        date_default_timezone_set('America/Guayaquil');
        $mesHoy=date("m");
        $anioHoy=date("Y");

        if($req['mes']!=0 ||$req['mes']=="")
            $mes=(isset($req['mes']))?$req['mes']:$mesHoy;
        else
            $mes=null;
        if($req['anio'] !=0 ||$req['anio']=="" )
            $anio=(isset($req['anio']))?$req['anio']:$anioHoy;
        else
            $anio=null;

        $piso=$req['piso'];

   
        return view('reports.listaIntegracion');
    }
    public function listaIntegracion(Request $req)
    {

        $this->_util->inicializaMenu($req);
        $req->session()->put('activeInt',  Lang::get('list.actIng'));
        $req->session()->put('varInt',  Lang::get('list.active'));
        $req->session()->put('breadCumbp',Lang::get('list.breadcumAcc'));
        $req->session()->put('breadCumbs',Lang::get('list.detailbreadcumAcc'));
        $req->session()->put('breadImg', Lang::get('list.icoAcc'));

        $user = Auth::user();

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');
        $idOrganizacion = null;
        if ($user->hasRole(['supadmin']) ) {
                $idOrganizacion = $req->input('empresa');
        } else {
                $empresa = EmpresaUser::where('iduser', $user->id)->first();
                $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();
                $idOrganizacion =$organizacion->org_id;
        }
        

        $sesiones = Sesexterna::join('configession', 'configession.idconf', '=', 'sesexterna.idconf')
                    ->join('cliente', 'cliente.cli_usuario', '=', 'configession.correo')
                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                    ->join('suscripcionv', 'organizacion.org_id', '=', 'suscripcionv.org_id')
                    ->where('organizacion.org_id', '=', $idOrganizacion)
                    ->where('sesexterna.fecha', '>=', DB::raw("GREATEST('$startDate', suscripcionv.sus_fecha_inicio)"))
                    ->where('sesexterna.fecha', '<=', $endDate)
                    ->select('sesexterna.idses',
                       'sesexterna.idsesion',
                       'sesexterna.fecha',
                       'sesexterna.emailaddress',
                       'sesexterna.nombre'
                    )
                    ->orderBy('fecha', 'desc')
                    ->paginate($this->_pages);


      $empresas = Organizacion::join('cliente', 'organizacion.org_id', '=', 'cliente.org_id')
            ->join('configession', 'cliente.cli_usuario', '=', 'configession.correo')
            ->select('organizacion.org_id', 'organizacion.org_nombre')
            ->get();

      return view('reports.listaintegracion',[
        'start_date' => $startDate,
        'end_date' => $endDate,
        'sesiones' => $sesiones,
        'empresas'=>$empresas
      ]);
    }

    public function listadescargas(Request $req){


       $this->_util->inicializaMenu($req);
        $req->session()->put('activeInt',  Lang::get('list.actIng'));
        $req->session()->put('varDes',  Lang::get('list.active'));
        $req->session()->put('breadCumbp',Lang::get('list.breadcumDes'));
        $req->session()->put('breadCumbs',Lang::get('list.detailbreadcumDes'));
        $req->session()->put('breadImg', Lang::get('list.icoDes'));

        $user = Auth::user();
        $mesHoy = date("m");
        $anioHoy = date("Y");
        $diaHoy = date("d");

      

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');

        $idOrganizacion = null;
        if ($user->hasRole(['supadmin']) ) {
                $idOrganizacion = $req->input('empresa');
        } else {
                $empresa = EmpresaUser::where('iduser', $user->id)->first();
                $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();
                $idOrganizacion =$organizacion->org_id;
        }
        

        $documents = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
                    ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id')
                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                    ->join('suscripcionv', 'organizacion.org_id', '=', 'suscripcionv.org_id')
                    ->where('organizacion.org_id', '=', $idOrganizacion)
                    ->where('topdoc.fecha_modifica', '>=', DB::raw("GREATEST('$startDate', suscripcionv.sus_fecha_inicio)"))
                    ->where('topdoc.fecha_modifica', '<=', $endDate)
                    ->select(
                      'documento.titulo',
                      'topdoc.fecha_modifica',
                      'topdoc.conteo',
                      'suscripcionv.sus_fecha_inicio'
                    )
                       ->orderBy('topdoc.fecha_modifica', 'desc')
                    ->paginate($this->_pages);


        $empresas = Organizacion::join('cliente', 'organizacion.org_id', '=', 'cliente.org_id')
            ->join('configession', 'cliente.cli_usuario', '=', 'configession.correo')
            ->select('organizacion.org_id', 'organizacion.org_nombre')
            ->get();

        return view('reports.listadescargas',[
        'start_date' => $startDate,
        'end_date' => $endDate,
        'documents' => $documents,
        'empresas'=>$empresas
      ]);

    }
public function listanotificaciones(Request $req){

        $this->_util->inicializaMenu($req);
        $req->session()->put('activeInt',  Lang::get('list.actIng'));
        $req->session()->put('varNot',  Lang::get('list.active'));
        $req->session()->put('breadCumbp',Lang::get('list.breadcumNot'));
        $req->session()->put('breadCumbs',Lang::get('list.detailbreadcumNot'));
        $req->session()->put('breadImg', Lang::get('list.icoNot'));

        $user = Auth::user();
        $mesHoy = date("m");
        $anioHoy = date("Y");
        $diaHoy = date("d");

      

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');
        $sus_fecha_inicio=date('2000-01-01');
        if ($user->hasRole(['supadmin']) ) {
                $idOrganizacion = $req->input('empresa');               
        } else {
                $empresa = EmpresaUser::where('iduser', $user->id)->first();
                $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();
                $idOrganizacion =$organizacion->org_id;
                
                $sus_fecha_inicio = Organizacion::select('organizacion.*', 'suscripcionv.sus_fecha_inicio')
                ->join('suscripcionv', 'organizacion.org_id', '=', 'suscripcionv.org_id')
                ->where('organizacion.org_id', $empresa->idemp)
                ->first();
        }


   

        $notifications = Notifications::where('vl_notificaciones.org_id', '=', $idOrganizacion)
                    ->where('vl_notificaciones.fechalectura', '>=', DB::raw("GREATEST('$startDate', '$sus_fecha_inicio')"))
                    ->where('vl_notificaciones.fechalectura', '<=', $endDate)
                    ->select(
                        'vl_notificaciones.org_id',
                        'vl_notificaciones.correo',
                        'vl_notificaciones.usuario',
                        'vl_notificaciones.fechalectura',
                        'vl_notificaciones.tipoboletin'
                    )
                       ->orderBy('vl_notificaciones.fechalectura', 'desc')
                    ->paginate($this->_pages);

        $empresas = Organizacion::join('cliente', 'organizacion.org_id', '=', 'cliente.org_id')
            ->join('configession', 'cliente.cli_usuario', '=', 'configession.correo')
            ->select('organizacion.org_id', 'organizacion.org_nombre')
            ->get();

        return view('reports.listanotificaciones',[
        'start_date' => $startDate,
        'end_date' => $endDate,
        'notifications' => $notifications,
        'empresas'=>$empresas
      ]);

    }
    public function listadocumentos(Request $req){
        $this->_util->inicializaMenu($req);
        $req->session()->put('activeInt',  Lang::get('list.actIng'));
        $req->session()->put('varDoc',  Lang::get('list.active'));
        $req->session()->put('breadCumbp',Lang::get('list.breadcumDoc'));
        $req->session()->put('breadCumbs',Lang::get('list.detailbreadcumDoc'));
        $req->session()->put('breadImg', Lang::get('list.icoDoc'));

        $user = Auth::user();

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ? $req->input('end_date') . ' 23:59:59' : date('Y-m-d') . ' 23:59:59';

        /*if ($user->hasRole(['superadmin']) ) {
                $idOrganizacion = $req->input('empresa');
        } else {
                $empresa = EmpresaUser::where('iduser', $user->id)->first();
                $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();
                $idOrganizacion =$organizacion->org_id;
        }*/

        $documents = Documento::join('folder2 as f2', 'f2.id_folder2', '=', 'documento.id_folder2')
            ->join('folder3 as f3', 'f3.id_folder3', '=', 'documento.id_folder3')
            ->where('documento.fecha_creacion', '>=', $startDate)
            ->where('documento.fecha_creacion', '<=', $endDate)
            ->select('documento.fecha_creacion', 'documento.titulo', 'f2.nombre as nombre1' , 'f3.nombre as nombre2' , 'documento.id_documento')
            ->orderBy('documento.fecha_creacion', 'desc')
            ->paginate($this->_pages);
            
        $empresas = Organizacion::join('cliente', 'organizacion.org_id', '=', 'cliente.org_id')
            ->join('configession', 'cliente.cli_usuario', '=', 'configession.correo')
            ->select('organizacion.org_id', 'organizacion.org_nombre')
            ->get();
        return view('reports.listadocumentos',[
        'start_date' => $startDate,
        'end_date' => date('Y-m-d', strtotime($endDate)),
        'documents' => $documents
        //'empresas'=>$empresas
      ]);
    }

  }
