<?php

namespace App\Http\Controllers;

use App\Mail\CampaniaInmo;
use App\Repositories\empresas_enviadoRepository;
use App\Repositories\empresasRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\Notifica;

class MailController extends Controller
{
    protected $_empresas;
    protected $_empresas_enviado;
    public function __CONSTRUCT(
        empresasRepository $_empresas,empresas_enviadoRepository $_empresas_enviado
    )
    {
        $this->_empresas = $_empresas;
        $this->_empresas_enviado = $_empresas_enviado;
    }
    public function index( )
    {
        return view('emails.index');
    }
    public function contacto( )
    {
        return view('emails.contacto');
    }

    public function listaInmo(Request $req){
        $empresas=$this->finEmpresa();
        //dd($empresas);
        $email='fausto.laminia@gmail.com';
        $nombre='L&G compania';
        $req['estado']=true;
        foreach ($empresas as $val){
            Mail::to($val->email)->send(new CampaniaInmo($val->nombre));
            $req['fechaenvio']=date("Y-m-d H:i:s.u");
            $req['idenvio']=$val->id;
            $data = (object)[
                'idenvio'=>$req->input('idenvio'),
                'idcampa' => $req->input('idcampa'),
                'fechaenvio' => $req->input('fechaenvio'),
                'estado' => $req->input('estado')
            ];
            //dd($data);
            $this->_empresas_enviado->save($data);
        }
         return view('emails.index');
    }
    public function listaSoftware(Request $req){
        $empresas=$this->finEmpresa();
        $email='fausto.laminia@gmail.com';
        $nombre='L&G compania';
        foreach ($empresas as $val){
            //Mail::to($val->email)->send(new CampaniaInmo($val->nombre));
            Mail::to($email)->send(new CampaniaInmo($nombre));
            $req['fechaenvio']=date("Y-m-d H:i:s.u");
            $req['idenvio']=$val->id;
            $data = (object)[
                'idenvio'=>$req->input('idenvio'),
                'idcampa' => $req->input('idcampa'),
                'fechaenvio' => $req->input('fechaenvio'),
                'estado' => $req->input('estado')
            ];
            $this->_empresas_enviado->save($data);
        }
        return view('emails.index');
    }
    public function finEmpresa()
    {
        return  $this->_empresas
            ->findBlockEnviado();
    }
    public function findCount()
    {
        return  $this->_empresas
            ->findCount();
    }
}