<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Clases\Utilidades;
use App\Models\Sesexterna;
use App\Models\Topdoc;
use Illuminate\Http\Request;
use App\Models\Notifications;
use App\Models\Organizacion;
use App\Models\tbempresauser as EmpresaUser; // Ensure this model exists or is correctly referenced
use DB;
use Microsoft\Graph\Generated\Models\Organization;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $_util;

    public function __construct()
    {
        $this->middleware('auth');
        $this->_util = new Utilidades();
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $req)
    {
        $user = Auth::user();
       // Coloca valores para menu activo y breadcumbs
        $this->_util->inicializaMenu($req);
        $req->session()->put('varHome', 'active');
        $req->session()->put('breadCumbp', 'Dashboard');
        $req->session()->put('breadCumbs', 'Panel de control sistema');
        $req->session()->put('breadImg', 'fa fa-tachometer');
        date_default_timezone_set('America/Guayaquil');

        $mesHoy = date("m");
        $anioHoy = date("Y");
        $diaHoy = date("d");

      

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');
        $idOrganizacion=null;
        
        //exit();
        if($req->input('empresa')===NULL){
            $empresa = EmpresaUser::where('iduser', $user->id)->first();
            $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();
            $idOrganizacion = $organizacion ? $organizacion->org_id : null;
        }else{
            $idOrganizacion=$req->input('empresa');
        }

        $sessionData = Sesexterna::join('configession', 'configession.idconf', '=', 'sesexterna.idconf')
                                ->join('cliente', 'cliente.cli_usuario', '=', 'configession.correo')
                                ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                                ->where('organizacion.org_id', '=',$idOrganizacion )
                                ->where('sesexterna.fecha', '>=', $startDate)
                                ->where('sesexterna.fecha', '<=', $endDate)
                                ->select(
                                DB::raw('COUNT(*) AS total'),
                                DB::raw( 'CONCAT(YEAR(`sesexterna`.`fecha`),\'-\',MONTH(`sesexterna`.`fecha`)) AS nombre'),
                                DB::raw('YEAR(`sesexterna`.`fecha`) AS anio'),
                                DB::raw('MONTH(`sesexterna`.`fecha`) AS mes'),
                                    )
                                ->groupBy( DB::raw('CONCAT(YEAR(`sesexterna`.`fecha`),\'-\',MONTH(`sesexterna`.`fecha`))'),
                                        DB::raw('YEAR(`sesexterna`.`fecha`)'),
                                        DB::raw('MONTH(`sesexterna`.`fecha`)'))
                                ->orderBy('anio', 'asc')
                                ->get()
                                ->toArray();

        $sessionSize = Sesexterna::join('configession', 'configession.idconf', '=', 'sesexterna.idconf')
                                    ->join('cliente', 'cliente.cli_usuario', '=', 'configession.correo')
                                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                                    ->where('organizacion.org_id', '=',$idOrganizacion )
                                    ->where('sesexterna.fecha', '>=',$startDate)
                                    ->where('sesexterna.fecha', '<=',$endDate)
                                    ->count('organizacion.org_id');

        $sessionMesData = Sesexterna::join('configession', 'configession.idconf', '=', 'sesexterna.idconf')
                                    ->join('cliente', 'cliente.cli_usuario', '=', 'configession.correo')
                                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                                    ->where('organizacion.org_id', '=', $idOrganizacion )
                                    ->where('sesexterna.fecha', '>=', $startDate)
                                    ->where('sesexterna.fecha', '<=', $endDate)
                                    ->select(
                                    DB::raw('COUNT(*) AS total'),
                                        DB::raw( 'MONTHNAME(`sesexterna`.`fecha`) AS mesNombre'),
                                        DB::raw('MONTH(`sesexterna`.`fecha`) AS mes'),
                                        )
                                    ->groupBy(  DB::raw( 'MONTHNAME(`sesexterna`.`fecha`)'),
                                                        DB::raw('MONTH(`sesexterna`.`fecha`)')
                                        )
                                    ->orderBy('mes', 'asc')
                                    ->get()
                                    ->toArray();


        $documentMonthData = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
                                    ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id')
                                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                                    ->where('organizacion.org_id', '=', $idOrganizacion )
                                    ->where('topdoc.fecha_modifica', '>=', $startDate)
                                    ->where('topdoc.fecha_modifica', '<=', $endDate)
                                    ->select(
                                    DB::raw('SUM(conteo) AS total'),
                                    //'documento.titulo',
                                        DB::raw( 'CONCAT(YEAR(`topdoc`.`fecha_modifica`),\'-\',MONTH(`topdoc`.`fecha_modifica`)) AS nombre'),
                                        DB::raw('YEAR(`topdoc`.`fecha_modifica`) AS anio'),
                                        DB::raw('MONTH(`topdoc`.`fecha_modifica`) AS mes'),
                                        )
                                    ->groupBy(  //'documento.titulo',
                                        DB::raw( 'CONCAT(YEAR(`topdoc`.`fecha_modifica`),\'-\',MONTH(`topdoc`.`fecha_modifica`))'),
                                        DB::raw('YEAR(`topdoc`.`fecha_modifica`)'),
                                        DB::raw('MONTH(`topdoc`.`fecha_modifica`)')
                                        )
                                    ->orderBy('anio', 'asc')
                                    ->orderBy('mes', 'asc')
                                    ->get()
                                    ->toArray();

        $documentSize = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
                                    ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id')
                                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                                    ->where('organizacion.org_id', '=', $idOrganizacion )
                                    ->where('topdoc.fecha_modifica', '>=', $startDate)
                                    ->where('topdoc.fecha_modifica', '<=', $endDate)
                                    ->sum('conteo');

        $notificationMonthData = Notifications::where('vl_notificaciones.org_id', '=', $idOrganizacion )
                                    ->where('vl_notificaciones.fechalectura', '>=', $startDate)
                                    ->where('vl_notificaciones.fechalectura', '<=', $endDate)
                                    ->select(
                                    DB::raw('count(vl_notificaciones.usuario) AS total'),
                                    //'vl_notificaciones.usuario',
                                        DB::raw( 'CONCAT(YEAR(`vl_notificaciones`.`fechalectura`),\'-\',MONTH(`vl_notificaciones`.`fechalectura`)) AS nombre'),
                                        DB::raw('YEAR(`vl_notificaciones`.`fechalectura`) AS anio'),
                                        DB::raw('MONTH(`vl_notificaciones`.`fechalectura`) AS mes'),
                                        )
                                    ->groupBy(  
                                    //'vl_notificaciones.usuario',
                                        DB::raw( 'CONCAT(YEAR(`vl_notificaciones`.`fechalectura`),\'-\',MONTH(`vl_notificaciones`.`fechalectura`))'),
                                        DB::raw('YEAR(`vl_notificaciones`.`fechalectura`)'),
                                        DB::raw('MONTH(`vl_notificaciones`.`fechalectura`)')
                                        )
                                    ->orderBy('anio', 'asc')
                                    ->orderBy('mes', 'asc')
                                    ->get()
                                    ->toArray();

        $notificationSize = Notifications::where('vl_notificaciones.org_id', '=', $idOrganizacion )
                                    ->where('vl_notificaciones.fechalectura', '>=', $startDate)
                                    ->where('vl_notificaciones.fechalectura', '<=', $endDate)
                                    ->count('*');                              
                           


        //Obener datos para el superadmin
        if(Auth::user()->hasRole(['supadmin'])){
            $integracionsAdmin = Organizacion::from('organizacion as o')
                ->join('cliente as c', 'o.org_id', '=', 'c.org_id')
                ->join('configession as cf', 'c.cli_usuario', '=', 'cf.correo')
                ->join('sesexterna as s', 'cf.idconf', '=', 's.idconf')
                ->where('s.fecha', '>=', $startDate)
                ->where('s.fecha', '<=', $endDate)
                ->select(
                    DB::raw('COUNT(s.idconf) as total_sessions'),
                    'o.org_id',
                    'o.org_nombre'
                )
                ->groupBy('o.org_id', 'o.org_nombre')
                ->get();

        $integracionsAdminSize = Organizacion::from('organizacion as o')
            ->join('cliente as c', 'o.org_id', '=', 'c.org_id')
            ->join('configession as cf', 'c.cli_usuario', '=', 'cf.correo') 
            ->join('sesexterna as s', 'cf.idconf', '=', 's.idconf')
            ->where('s.fecha', '>=', $startDate)
            ->where('s.fecha', '<=', $endDate)
            ->count('s.idconf');

        $documentAdmin = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
            ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id') 
            ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
            ->where('topdoc.fecha_modifica', '>=', $startDate)
            ->where('topdoc.fecha_modifica', '<=', $endDate)
            ->select(
                DB::raw('SUM(conteo) as total'),
                'organizacion.org_nombre'
            )
            ->groupBy('organizacion.org_nombre')
            ->orderBy('organizacion.org_nombre', 'asc')
            ->get();

        $documentAdminSize = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
            ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id')
            ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id') 
            ->where('topdoc.fecha_modifica', '>=', $startDate)
            ->where('topdoc.fecha_modifica', '<=', $endDate)
            ->sum('conteo');
        
                
        }

    if(Auth::user()->hasRole(['supadmin'])){
            return view('home', [
                'anio' => $anioHoy,
                'start_date' => $startDate,
                'end_date' => $endDate,
                'userAssigned' => [],
                'userAssignedSize' => 0,
                'documentAdmin' => $documentAdmin,
                'documentAdminSize' => $documentAdminSize,
                'integracionsAdmin' => $integracionsAdmin,
                'integracionsAdminSize' => $integracionsAdminSize,
                'model' => $sessionData
            ]);
        } else {
            return view('home', [
                'anio' => $anioHoy,
                'start_date' => $startDate,
                'end_date' => $endDate,
                'sessionSize' => $sessionSize,
                'sessionData' => $sessionData,
                'sessionMesData' => $sessionMesData,
                'documentMonthData' => $documentMonthData,
                'documentSize' => $documentSize,
                'userAssigned' => [],
                'userAssignedSize' => 0,
                'notifications' => $notificationMonthData,
                'notificationSize' => $notificationSize,
                'model' => $sessionData
            ]);
        }
       
    }
 public function downloadAcces(Request $req)
    {

        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');

        $user = Auth::user();
        $empresa = EmpresaUser::where('iduser', $user->id)->first();
        $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();

        $sessionMesData = Sesexterna::join('configession', 'configession.idconf', '=', 'sesexterna.idconf')
                    ->join('cliente', 'cliente.cli_usuario', '=', 'configession.correo')
                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                    ->where('organizacion.org_id', '=', $organizacion->org_id)
                    ->where('sesexterna.fecha', '>=', $startDate)
                    ->where('sesexterna.fecha', '<=', $endDate)
                    ->select('sesexterna.idconf',
                                'sesexterna.fecha',
                                'sesexterna.emailaddress',
                                'sesexterna.idsesion'
                    )->orderBy('sesexterna.fecha', 'asc')
                    ->get();
        // Export to Excel
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        
        // Add header image
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Header Image');
        $drawing->setDescription('Header Image');
        $drawing->setPath(public_path("assets/temptk/img/Virtualex400pxN.png")); // Path to your image
        $drawing->setHeight(50);
        $drawing->setCoordinates('A1');
        $drawing->setWorksheet($sheet);

        // Set header
        $sheet->setCellValue('A4', strtoupper($organizacion->org_nombre));
        $sheet->setCellValue('A5', strtoupper('Reporte de accesos al sistema web'));
        $sheet->setCellValue('A6', strtoupper("Periodo: del $startDate al $endDate"));
        $sheet->getStyle('A4:A6')->getFont()->setBold(true);
        $sheet->getStyle('A4:A6')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->mergeCells('A4:D4');
        $sheet->mergeCells('A5:D5');
        $sheet->mergeCells('A6:D6');
        
        // Set column headers
        $sheet->setCellValue('A7', 'Id');
        $sheet->setCellValue('B7', 'Fecha');
        $sheet->setCellValue('C7', 'Email');
        $sheet->setCellValue('D7', 'Id Sesion');
        // Agrega borde a las celdas del encabezado
        $sheet->getStyle('A7:D7')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        
        // Make column headers bold
        $sheet->getStyle('A7:D7')->getFont()->setBold(true);

        $rowNumber = 8;
        foreach ($sessionMesData as $row) {
            $sheet->setCellValue('A' . $rowNumber, $rowNumber-7);
            $sheet->setCellValue('B' . $rowNumber, $row['fecha']);
            $sheet->setCellValue('C' . $rowNumber, $row['emailaddress']);
            $sheet->setCellValue('D' . $rowNumber, $row['idsesion']);
            $sheet->getStyle('A' . $rowNumber . ':D' . $rowNumber)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
            $rowNumber++;
        }

        // Adjust column width
        foreach (range('A', 'D') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        // Adjust row height
        foreach ($sheet->getRowDimensions() as $rd) {
            $rd->setRowHeight(-1);
        }

        $writer = new Xlsx($spreadsheet);
        $writer->setIncludeCharts(true);
        $filename = "session_data_{$startDate}_to_{$endDate}.xlsx";

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment; filename=\"$filename\"");

        $writer->save('php://output');
        exit;
    }
    public function downloadDocument(Request $req)
    {
        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');

        $user = Auth::user();
        $empresa = EmpresaUser::where('iduser', $user->id)->first();
        $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();

        $documentData = Topdoc::join('documento', 'documento.id_documento', '=', 'topdoc.id_documento')
                    ->join('cliente', 'cliente.cli_id', '=', 'topdoc.cli_id')
                    ->join('organizacion', 'organizacion.org_id', '=', 'cliente.org_id')
                    ->where('organizacion.org_id', '=', $organizacion->org_id)
                    ->where('topdoc.fecha_modifica', '>=', $startDate)
                    ->where('topdoc.fecha_modifica', '<=', $endDate)
                    ->select('topdoc.id_documento', 'documento.titulo', 'topdoc.fecha_modifica', 'topdoc.conteo')
                    ->orderBy('topdoc.fecha_modifica', 'asc')
                    ->get();

        // Export to Excel
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        
        // Set header
        // Add header image
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Header Image');
        $drawing->setDescription('Header Image');
        $drawing->setPath(public_path("assets/temptk/img/Virtualex400pxN.png")); // Path to your image
        $sheet->getRowDimension(1)->setRowHeight(60); // Add extra space after logo
        $sheet->getRowDimension(2)->setRowHeight(20); // Add spacing for next row
        $drawing->setHeight(50);
        $drawing->setCoordinates('A1');
        $drawing->setWorksheet($sheet);

        // Set header
        $sheet->setCellValue('A4', strtoupper($organizacion->org_nombre));
        $sheet->setCellValue('A5', strtoupper('Reporte de descargas de documentos'));
        $sheet->setCellValue('A6', strtoupper("Periodo: del $startDate al $endDate"));
        $sheet->getStyle('A4:A6')->getFont()->setBold(true);
        $sheet->getStyle('A4:A6')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->mergeCells('A4:D4');
        $sheet->mergeCells('A5:D5');
        $sheet->mergeCells('A6:D6');
        
        // Set column headers
        $sheet->setCellValue('A7', 'Fecha Descarga');
        $sheet->setCellValue('B7', 'Titulo');
        $sheet->getColumnDimension('B')->setWidth(28);
        $sheet->setCellValue('C7', 'No. descargas');
        // Agrega borde a las celdas del encabezado
        $sheet->getStyle('A7:C7')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        // Make column headers bold
        $sheet->getStyle('A7:C7')->getFont()->setBold(true);

        $rowNumber = 8;
        $totalDescargas = 0;
        foreach ($documentData as $row) {
            $totalDescargas += $row['conteo'];
            $sheet->setCellValue('A' . $rowNumber, $row['fecha_modifica']);
            $sheet->setCellValue('B' . $rowNumber, $row['titulo']);            
            $sheet->setCellValue('C' . $rowNumber, $row['conteo']);
            $sheet->getStyle('A' . $rowNumber . ':C' . $rowNumber)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
            $rowNumber++;
        }
        // Combina las celdas A y B para mostrar "Total Descargas" centrado
        $sheet->mergeCells('A' . $rowNumber . ':B' . $rowNumber);
        $sheet->setCellValue('A' . $rowNumber, 'Total Descargas');
        $sheet->getStyle('A' . $rowNumber . ':B' . $rowNumber)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->setCellValue('C' . $rowNumber, $totalDescargas);
        $sheet->getStyle('A' . $rowNumber . ':C' . $rowNumber)->getFont()->setBold(true);
        $sheet->getStyle('A' . $rowNumber . ':C' . $rowNumber)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

        // Adjust column width
        foreach (range('A', 'C') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        // Adjust row height
        foreach ($sheet->getRowDimensions() as $rd) {
            $rd->setRowHeight(-1);
        }

        $writer = new Xlsx($spreadsheet);
        $filename = "document_data_{$startDate}_to_{$endDate}.xlsx";

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment; filename=\"$filename\"");

        $writer->save('php://output');
        exit;
    }

    public function downloadBulletins(Request $req)
    {
        $startDate = $req->input('start_date') ?: date('Y-m-01');
        $endDate = $req->input('end_date') ?: date('Y-m-d');

        $user = Auth::user();
        $empresa = EmpresaUser::where('iduser', $user->id)->first();
        $organizacion = Organizacion::where('org_id', $empresa->idemp)->first();

        $bulletinData = Notifications::where('vl_notificaciones.org_id', '=', $organizacion->org_id)
                    ->where('vl_notificaciones.fechalectura', '>=', $startDate)
                    ->where('vl_notificaciones.fechalectura', '<=', $endDate)
                    ->select(
                       'vl_notificaciones.usuario',
                    'vl_notificaciones.fechalectura',
                    'vl_notificaciones.correo',
                    'vl_notificaciones.tipoboletin'
                    )
                       ->orderBy('fechalectura', 'asc')
                    ->get();
        // Export to Excel
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        
        // Add header image
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Header Image');
        $drawing->setDescription('Header Image');
        $drawing->setPath(public_path("assets/temptk/img/Virtualex400pxN.png")); // Path to your image
        $drawing->setHeight(50);
        $drawing->setCoordinates('A1');
        $drawing->setWorksheet($sheet);

        // Set header
        $sheet->setCellValue('A4', strtoupper($organizacion->org_nombre));
        $sheet->setCellValue('A5', strtoupper('Reporte de boletines'));
        $sheet->setCellValue('A6', strtoupper("Periodo: del $startDate al $endDate"));
        $sheet->getStyle('A4:A6')->getFont()->setBold(true);
        $sheet->getStyle('A4:A6')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        $sheet->mergeCells('A4:E4');
        $sheet->mergeCells('A5:E5');
        $sheet->mergeCells('A6:E6');
        
        // Set column headers
        $sheet->setCellValue('A7', 'Id');
        $sheet->setCellValue('B7', 'Usuario');
        $sheet->setCellValue('C7', 'Fecha Lectura');
        $sheet->setCellValue('D7', 'Correo');
        $sheet->setCellValue('E7', 'Tipo Boletin');
        
        // Make column headers bold
        $sheet->getStyle('A7:E7')->getFont()->setBold(true);

        $rowNumber = 8;
        foreach ($bulletinData as $row) {
            $sheet->setCellValue('A' . $rowNumber, $rowNumber-7);
            $sheet->setCellValue('B' . $rowNumber, $row['usuario']);
            $sheet->setCellValue('C' . $rowNumber, $row['fechalectura']);
            $sheet->setCellValue('D' . $rowNumber, $row['correo']);
            $sheet->setCellValue('E' . $rowNumber, $row['tipoboletin']);
            $sheet->getStyle('A' . $rowNumber . ':E' . $rowNumber)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
            $rowNumber++;
        }

        // Adjust column width
        foreach (range('A', 'E') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        // Adjust row height
        foreach ($sheet->getRowDimensions() as $rd) {
            $rd->setRowHeight(-1);
        }

        $writer = new Xlsx($spreadsheet);
        $filename = "bulletin_data_{$startDate}_to_{$endDate}.xlsx";

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment; filename=\"$filename\"");

        $writer->save('php://output');
        exit;
    }
}
